<?php

namespace App\Http\Controllers\TherapistCommunitys;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Podcast;
use App\Http\Requests\TherapistCommunitys\TherapistCommunityPodcasts\CreateRequest;
use App\Http\Resources\Web\PodcastsResource;
use Excel;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class TherapistCommunityPodcastsController extends Controller
{
    /********* Initialize Permission based Middlewares  ***********/
  public function __construct()
  {
      $this->middleware('auth');
      $this->middleware('therapist_community');
      // $this->middleware('permission:therapist_community_podcasts.index');
      // $this->middleware('permission:therapist_community_podcasts.create',['only' => ['store']]);
      // $this->middleware('permission:therapist_community_podcasts.update',['only' => ['update']]);
      // $this->middleware('permission:therapist_community_podcasts.delete',['only' => ['destroy']]);
      // $this->middleware('permission:therapist_community_podcasts.export',['only' => ['export']]);
      // $this->middleware('permission:therapist_community_podcasts.import',['only' => ['import']])
      // $this->middleware('permission:therapist_community_podcasts.update|therapist_community_podcasts.is_active',['only' => ['updateStatus']]);
  }

  /********* Getter For Pagination, Searching And Sorting  ***********/
  public function getter($req = null,$export = null)
  {
    $therapist_community = auth()->user()->therapist_community;
    if($req != null){
      $therapist_community_podcasts =  $therapist_community->therapist_community_podcasts()->withAll();
      if($req->trash && $req->trash == 'with'){
        $therapist_community_podcasts =  $therapist_community_podcasts->withTrashed();
      }
      if($req->trash && $req->trash == 'only'){
        $therapist_community_podcasts =  $therapist_community_podcasts->onlyTrashed();
      }
      if($req->column && $req->column != null && $req->search != null){
          $therapist_community_podcasts = $therapist_community_podcasts->whereLike($req->column,$req->search);
        }
       else if($req->search && $req->search != null){

            $therapist_community_podcasts = $therapist_community_podcasts->whereLike(['name','description'],$req->search);
        }
      if($req->sort && $req->sort['field'] != null && $req->sort['type'] != null){
          $therapist_community_podcasts = $therapist_community_podcasts->OrderBy($req->sort['field'],$req->sort['type']);
      }
      else
      {
        $therapist_community_podcasts = $therapist_community_podcasts->OrderBy('id','desc');
      }
      if($export != null){ // for export do not paginate
        $therapist_community_podcasts = $therapist_community_podcasts->get();
        return $therapist_community_podcasts;
      }
      $totalTherapistCommunityPodcasts = $therapist_community_podcasts->count();
      $therapist_community_podcasts = $therapist_community_podcasts->paginate($req->perPage);
      $therapist_community_podcasts = PodcastsResource::collection($therapist_community_podcasts)->response()->getData(true);

      return $therapist_community_podcasts;
    }
    $therapist_community_podcasts = PodcastsResource::collection($therapist_community->therapist_community_podcasts()->withAll()->orderBy('id','desc')->paginate(10))->response()->getData(true);
    return $therapist_community_podcasts;
  }

  /********* FETCH ALL TherapistCommunityPodcasts ***********/
    public function index()
    {
        $therapist_community_podcasts =  $this->getter();
        $response = generateResponse($therapist_community_podcasts,count($therapist_community_podcasts['data']) > 0 ? true:false,'TherapistCommunityPodcasts Fetched Successfully',null,'collection');
        return response()->json($response, 200);
    }

  /********* FILTER TherapistCommunityPodcasts FOR Search ***********/
   public function filter(Request $request){
     $therapist_community_podcasts = $this->getter($request);
     $response = generateResponse($therapist_community_podcasts,count($therapist_community_podcasts['data']) > 0 ? true:false,'Filter TherapistCommunityPodcasts Successfully',null,'collection');
     return response()->json($response, 200);
   }

    /********* ADD NEW TherapistCommunityPodcast ***********/
    public function store(CreateRequest $request)
    {
      $therapist_community = auth()->user()->therapist_community;
      try{
      DB::beginTransaction();
      $request->merge(['created_by_user_id'=>auth()->user()->id]);
      $data = $request->all();
      $data['image'] = uploadCroppedFile($request,'image','therapist_community_podcasts');
      $data['audio'] = uploadFile($request,'audio','therapist_community_podcasts');
      $data['video'] = uploadFile($request,'video','therapist_community_podcasts');
      $therapist_community_podcast = $therapist_community->therapist_community_podcasts()->create($data);
      $therapist_community_podcast->slug = Str::slug($therapist_community_podcast->name . ' ' . $therapist_community_podcast->id, '-');
      $therapist_community_podcast->save();
      $therapist_community_podcast = $therapist_community->therapist_community_podcasts()->withAll()->find($therapist_community_podcast->id);
      $therapist_community_podcast = new PodcastsResource($therapist_community_podcast);
      $therapist_community_podcast->tags()->sync($request->tag_ids);
      DB::commit();
    }
      catch (\Exception $e) {
        DB::rollBack();
        request()->session()->flash('alert',['message' => 'Invalid Request','type' => 'error']);
     }
      return redirect()->back();
    }

    /********* View RECORD TO EDIT Or Display ***********/
    public function show( $therapist_community_podcast)
    {
        $therapist_community = auth()->user()->therapist_community;
        if($therapist_community_podcast->therapist_community_id != $therapist_community->id){
            return redirect()->back()->withErrors([
                'message' => 'Invalid Request',
                'type' => 'error'
            ]);
        }
        $therapist_community_podcast = $therapist_community->therapist_community_podcasts()->withAll()->find($therapist_community_podcast);
        if($therapist_community_podcast){
          $therapist_community_podcast = new PodcastsResource($therapist_community_podcast);
          $response = generateResponse($therapist_community_podcast,true,'TherapistCommunityPodcast Fetched Successfully',null,'object');
        }
        else{
          $response = generateResponse(null,false,'TherapistCommunityPodcast Not FOund',null,'object');
        }
        return response()->json($response, 200);
    }

    /********* UPDATE TherapistCommunityPodcast ***********/
    public function update(CreateRequest $request, Podcast $therapist_community_podcast)
    {
        // dd($request->all());
        $therapist_community = auth()->user()->therapist_community;
        if($therapist_community_podcast->therapist_community_id != $therapist_community->id){
            return redirect()->back()->withErrors([
                'message' => 'Invalid Request',
                'type' => 'error'
            ]);
        }
      try{
        DB::beginTransaction();
        $request->merge(['last_updated_by_user_id'=>auth()->user()->id]);
        $data = $request->all();
        if ($request->image) {
            $data['image'] = uploadCroppedFile($request,'image','therapist_community_podcasts',$therapist_community_podcast->image);
        } else {
            $data['image'] = $therapist_community_podcast->image;
        }

        if ($request->audio) {
            $data['audio'] = uploadFile($request,'audio','therapist_community_podcasts');
        } else {
            $data['audio'] = $therapist_community_podcast->audio;
        }

        if ($request->video) {
            $data['video'] = uploadFile($request,'video','therapist_community_podcasts');
        } else {
            $data['video'] = $therapist_community_podcast->video;
        }
        $therapist_community_podcast->update($data);
        $therapist_community_podcast = $therapist_community_podcast->find($therapist_community_podcast->id);
        $slug = Str::slug($therapist_community_podcast['name'] . ' ' . $therapist_community_podcast->id, '-');
        $therapist_community_podcast->update(
            [
                'slug' => $slug
            ]
        );
        $therapist_community_podcast->tags()->sync($request->tag_ids);
        DB::commit();
      }
        catch (\Exception $e) {
            dd($e->getMessage());
          DB::rollBack();
          request()->session()->flash('alert',['message' => 'Invalid Request','type' => 'error']);
       }
       return redirect()->back();
    }

    /********* UPDATE TherapistCommunityPodcast Status***********/
    public function updateStatus(Request $request,Podcast $therapist_community_podcast){
        $therapist_community = auth()->user()->therapist_community;
        if($therapist_community_podcast->therapist_community_id != $therapist_community->id){
            return redirect()->back()->withErrors([
                'message' => 'Invalid Request',
                'type' => 'error'
            ]);
        }
        $therapist_community_podcast->update([
          'is_active' => $therapist_community_podcast->is_active == 1 ? 0:1
        ]);
        $response = generateResponse(null,true,'TherapistCommunityPodcast Status Updated Successfully',null,'object');
        return response()->json($response, 200);
    }


    /********* DELETE TherapistCommunityPodcast ***********/
    public function destroy(Request $request,Podcast $therapist_community_podcast)
    {
        $therapist_community = auth()->user()->therapist_community;
        if($therapist_community_podcast->therapist_community_id != $therapist_community->id){
            request()->session()->flash('alert',['message' => 'Invalid Request','type' => 'error']);
            return redirect()->back();
        }
          if($therapist_community_podcast->trashed()) {
            request()->session()->flash('alert',['message' => 'Already in Trash','type' => 'error']);
          }
          else{
            $therapist_community_podcast->delete();
          }
          return redirect()->back();
    }
    /*********Permanently DELETE TherapistCommunityPodcast ***********/
    public function destroyPermanently(Request $request,$therapist_community_podcast)
    {
        $therapist_community= auth()->user()->therapist_community;
        $therapist_community_podcast = $therapist_community->therapist_community_podcasts()->withTrashed()->find($therapist_community_podcast);
        if($therapist_community_podcast){
            if($therapist_community_podcast->therapist_community_id != $therapist_community->id){
                return redirect()->back()->withErrors([
                    'message' => 'Invalid Request',
                    'type' => 'error'
                ]);
            }
          if ($therapist_community_podcast->trashed()) {
            $therapist_community_podcast->forceDelete();
            $response = generateResponse(null,true,'TherapistCommunityPodcast Deleted Successfully',null,'object');
          }
          else{
            $response = generateResponse(null,false,'TherapistCommunityPodcast is not in trash to delete permanently',null,'object');
          }
        }
        else{
          $response = generateResponse(null,false,'TherapistCommunityPodcast not found',null,'object');
        }
          return response()->json($response, 200);
    }
    /********* Restore TherapistCommunityPodcast ***********/
    public function restore(Request $request,$therapist_community_podcast)
    {
      $therapist_community= auth()->user()->therapist_community;
      $therapist_community_podcast = $therapist_community->therapist_community_podcasts()->withTrashed()->find($therapist_community_podcast);
          if ($therapist_community_podcast->trashed()) {
            $therapist_community_podcast->restore();
            $response = generateResponse(null,true,'TherapistCommunityPodcast Restored Successfully',null,'object');
          }
          else{
            $response = generateResponse(null,false,'TherapistCommunityPodcast is not trashed',null,'object');
          }
          return response()->json($response, 200);
    }
}
